/*
  rects.c
  
  SDL Example
  Show some rectangles
  
  Bill Kendrick
  12/1999
*/


#include <stdio.h>
#include <stdlib.h>
#include <SDL/SDL.h>


int main(int argc, char * argv[])
{
  SDL_Surface * scr;
  SDL_Rect rect;
  int i;
  Uint8 r, g, b;
  
  
  /* Init SDL: */
  
  if (SDL_Init(SDL_INIT_VIDEO) < 0 )
    {
      fprintf(stderr, "Can't init: %s\n",
	      SDL_GetError());
      exit(1);
    }
  
  
  /* Open screen: */
  
  scr = SDL_SetVideoMode(640, 480, 16,
			 SDL_HWSURFACE);
  
  
  for (i = 0; i < 64; i++)
    {
      /* Determine where to draw rect: */
      
      rect.x = i * 10;
      rect.y = i * 7;
      rect.w = 100;
      rect.h = 50;
      
      
      /* What color should it be? */
      
      r = (i * 4);
      g = ((64 - i) * 4);
      b = (i % 4) * 64;
      
      
      /* Draw a rectangle on the screen: */
      
      SDL_FillRect(scr, &rect,
		   SDL_MapRGB(scr->format,
			      r, g, b));
      
      SDL_UpdateRect(scr,
		     rect.x, rect.y,
		     rect.w, rect.h);
    }
  
  
  /* Wait five seconds: */
  
  SDL_Delay(5000);
  
  
  /* Quit: */
  
  SDL_Quit();
  
  return(0);
}
