/*
  mixer-demo.c
  
  SDL Example
  Play a song and some sounds.
  
  Bill Kendrick
  12/1999
*/


#include <stdio.h>
#include <stdlib.h>
#include <SDL/SDL.h>
#include <mixer.h>


int main(int argc, char * argv[])
{
  Mix_Chunk * sample;
  Mix_Music * song;
  
  
  /* Init SDL: */
  
  SDL_Init(SDL_INIT_AUDIO);
  
  
  /* Open mixer: */
  
  Mix_OpenAudio(MIX_DEFAULT_FREQUENCY,
                MIX_DEFAULT_FORMAT,
                MIX_DEFAULT_CHANNELS, 512);


  /* Load a sample: */
  
  sample = Mix_LoadWAV("sample.wav");

  
  /* Load a song: */
  
  song = Mix_LoadMUS("song.mod");

  
  /* Begin playing the song: */

  Mix_PlayMusic(song, 0);


  /* Occasionally play the sample
     and wait for music to stop */

  do
    {
      /* Pause five seconds */

      SDL_Delay(5000);


      /* Play sample: */
      
      Mix_PlayChannel(-1, sample, 0);
    }
  while (Mix_PlayingMusic());


  /* Quit: */
  
  Mix_CloseAudio();

  SDL_Quit();
  
  return(0);
}
