/*
  events.c
  
  SDL Example
  Play a song and some sounds.
  
  Bill Kendrick
  12/1999
*/


#include <stdio.h>
#include <stdlib.h>
#include <SDL/SDL.h>


int main(int argc, char * argv[])
{
  SDL_Surface * scr;
  SDL_Event event;
  
  
  /* Init SDL: */
  
  SDL_Init(SDL_INIT_VIDEO);
  
  
  /* Open screen: */
  
  scr = SDL_SetVideoMode(320, 240, 16,
                         SDL_HWSURFACE);
               

  /* Handle events: */

  do
    {
      /* Get next event */

      SDL_WaitEvent(&event);


      /* Say something about the event: */

      if (event.type == SDL_ACTIVEEVENT)
        printf("Focus changed.\n");
      else if (event.type == SDL_KEYDOWN)
        printf("Key pressed.\n");
      else if (event.type == SDL_KEYUP)
        printf("Key released.\n");
      else if (event.type == SDL_QUIT)
        printf("Quit request.\n");
    }
  while (event.type != SDL_QUIT);


  /* Quit: */
  
  SDL_Quit();
  
  return(0);
}
