/*
  blit.c
  
  SDL Example
  Show some rectangles
  
  Bill Kendrick
  12/1999
*/


#include <stdio.h>
#include <stdlib.h>
#include <SDL/SDL.h>


int main(int argc, char * argv[])
{
  SDL_Surface * scr, * temp, * image;
  SDL_Rect dest;
  int x, y;
  
  
  /* Init SDL: */
  
  if (SDL_Init(SDL_INIT_VIDEO) < 0 )
    {
      fprintf(stderr, "Can't init: %s\n",
	      SDL_GetError());
      exit(1);
    }
  
  
  /* Open screen: */
  
  scr = SDL_SetVideoMode(640, 480, 16,
			 SDL_HWSURFACE);
  
  
  /* Load and convert image: */
  
  temp = SDL_LoadBMP("bmp.bmp");
  image = SDL_DisplayFormat(temp);
  SDL_FreeSurface(temp);
  
  
  /* Draw image onto the screen: */
  
  for (y = 0; y < 480;
       y = y + image -> h)
    {
      for (x = 0; x < 640;
	   x = x + image -> w)
	{
	  dest.x = x;
	  dest.y = y;
	  dest.w = image -> w;
	  dest.h = image -> h;
	  
	  SDL_BlitSurface(image, NULL,
			  scr, &dest);
	}
    }
  
  
  /* Update the entire screen: */
  
  SDL_UpdateRect(scr, 0, 0, 640, 480);
  
  
  /* Pause five seconds: */
  
  SDL_Delay(5000);
  
  
  /* Quit: */
  
  SDL_Quit();
  
  return(0);
}
