\ main.fs
host
create bin 17 allot
bin 1 + constant bin1
: clear  bin 17 erase ;
: get  clear 1 word count bin place ;
: change ( - n)  0 16 0 do 2* bin1 i + c@
   [char] - = if 1 + then loop ;
: encode ( - n)  get change bin c@ or ;
: mc  encode target , host ;

target
here
   ( !)mc -.-.--
   ( ")mc -...-
   (  )mc ----------------
   ( $)mc ...-..-
   (  )mc ----------------
   ( &)mc .-...
   ( ')mc --..--
   ( ()mc -.--.
   ( ) mc -.--.-
   (  )mc ----------------
   ( +)mc .-.-.
   ( ,)mc --..--
   ( -)mc -....-
   ( .)mc .-.-.-
   ( /)mc -..-.
\
   ( 0)mc -----
   ( 1)mc .----
   ( 2)mc ..---
   ( 3)mc ...--
   ( 4)mc ....-
   ( 5)mc .....
   ( 6)mc -....
   ( 7)mc --...
   ( 8)mc ---..
   ( 9)mc ----.
\
   ( :)mc ---...
   ( ;)mc -.-.-.
   (  )mc ----------------
   (  )mc ----------------
   (  )mc ----------------
   ( ?)mc ..--..
   ( @)mc .--.-.
\
   ( A)mc .-
   ( B)mc -...
   ( C)mc .-.-
   ( D)mc -..
   ( E)mc .
   ( F)mc ..-.
   ( G)mc --.
   ( H)mc ....
   ( I)mc ..
   ( J)mc .---
   ( K)mc -.-
   ( L)mc .-..
   ( M)mc --
   ( N)mc -.
   ( O)mc ---
   ( P)mc .--.
   ( Q)mc --.-
   ( R)mc .-.
   ( S)mc ...
   ( T)mc -
   ( U)mc ..-
   ( V)mc ...-
   ( W)mc .--
   ( X)mc -..-
   ( Y)mc -.--
   ( Z)mc --..
\
   (  )mc ----------------
   (  )mc ----------------
   (  )mc ----------------
   (  )mc ----------------
   ( _)mc ..--.-
   (  )mc ----------------
: table ( -a) # ;

\ Change lowercase to upper case and remove control characters
\ resulting in a number in the range 0-63 to index into table
: filter ( c - c)
   dup [ char ! ] # - -if 2drop 63 # ; then drop
   [ char a ] # - -if [ char a char ! - ] # + ; then
   [ char A char ! - ] # + 63 # min ;
: lookup ( i - n)  2* table + p! @p+ ;

\ milliseconds are very approximate
: ms ( n)  for 4000 # for next next ;
: time ( - a)  variable # ;
\ smallest unit of delay in Morse code
: space  time @ ms ;
: default  100 # time ! ;

\ Assembler: takes pins high or low
: off  13 low, ;
: on  13 high, ;

\ Flash the LED long or short delay
: dah  on space space
: dit  on space off space ;

\ Use early exit rather than "else"
: ditdah ( n - n)  -if dah ; then dit ;
\ Invalid characters from table have bit 3 (actually all bits) set
: decode ( n)  dup 8 # and if 2drop ; then drop
   dup 7 # and for ditdah 2* next
   drop space space space ;
: morse ( c)  filter lookup decode ;

: go  default time @
: custom ( n)  time !
   begin key dup emit morse again

